﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Paper_PaperByManualSelectionDetail : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
            BindPaperInfo();
    }
    private int paperID
    {
        get
        {
            int id=0;
            if (Int32.TryParse(Request.QueryString["paperID"], out id))
                return id;
            else
                return -1;
        }
    }


    private void BindPaperInfo()
    {
        if (paperID < 0)
            return;

        PaperByManualSelection paper = new BLLPaperByManuaSelection().GetPaper(paperID);
        if (paper != null)
        {
            rptSubjectOfFillBlankList.DataSource = paper.FillBlankList;
            rptSubjectOfFillBlankList.DataBind();
            lblFillBlankListCount.Text = paper.FillBlankList.Count.ToString();

            rptSubjectOfJudgeList.DataSource = paper.JudgeList;
            rptSubjectOfJudgeList.DataBind();
            lblJudgeListCount.Text = paper.JudgeList.Count.ToString();

            rptSubjectOfSingleSelectionList.DataSource = paper.SingleSelectionList;
            rptSubjectOfSingleSelectionList.DataBind();
            lblSingleSelectionCount.Text = paper.SingleSelectionList.Count.ToString();

            rptSubjectOfMultiSelectionList.DataSource = paper.MultiSelectionList;
            rptSubjectOfMultiSelectionList.DataBind();
            lblMultiSelectionCount.Text = paper.MultiSelectionList.Count.ToString();

            rptSubjectOfSimpleAnswerList.DataSource = paper.SimpleAnswerList;
            rptSubjectOfSimpleAnswerList.DataBind();
            lblSimpleAnswerCount.Text = paper.SimpleAnswerList.Count.ToString();

            lblPaperName.Text = paper.PaperName;
            lblPaperType.Text = paper.PaperType.DeptName;
        }

    }
}
