﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using Entity;
using BLL;

public partial class Admin_Subject_DelSubject : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            switch (subjectType)
            {
                case SubjectType.FillBlank :
                    new BLLSubjectOfFillBlank().DeleteSubject(subjectID);
                    Response.Redirect("SubjectOfFillBlankList.aspx");
                    break;
                case SubjectType.Judge:
                    new BLLSubjectOfJudge().DeleteSubject(subjectID);
                    Response.Redirect("SubjectOfJudgeList.aspx");
                    break;
                case SubjectType.SingleSelection:
                    new BLLSubjectOfSingleSelection().DeleteSubject(subjectID);
                    Response.Redirect("SubjectOfSingleSelectionList.aspx");
                    break;
                case SubjectType.MultiSelection:
                    new BLLSubjectOfMultiSelection().DeleteSubject(subjectID);
                    Response.Redirect("SubjectOfMultiSelectionList.aspx");
                    break;
                case SubjectType.SimpleAnswer:
                    new BLLSubjectOfSimpleAnswer().DeleteSubject(subjectID);
                    Response.Redirect("SubjectOfSimpleAnswerList.aspx");
                    break;
                default:
                    break;
            }
        }
    }

    private SubjectType subjectType
    {
        get { return (SubjectType)Helper.GetUrlParmValue("subjectType"); }
    }

    private int subjectID
    {
        get { return Helper.GetUrlParmValue("subjectID"); }
    }
}
