﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;
using Tool;

public partial class Admin_Subject_SubjectOfFillBlankList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if(!IsPostBack)
        {
            int pageNum=1;
            if (Request.QueryString["pageNum"] != null)
                pageNum = Convert.ToInt32(Request.QueryString["pageNum"]);
            BindSubjectList(pageNum);
        }
    }

    private const int PAGE_SIZE = 20;
    private void BindSubjectList(int pageNum)
    {
        PageList<SubjectOfFillBlank> list = new BLLSubjectOfFillBlank().GetSubjectList(pageNum, PAGE_SIZE);
        rptSubjectOfFillBlankList.DataSource = list.RecorderList;
        rptSubjectOfFillBlankList.DataBind();
        lblPageUrl.Text = StringHelper.MakePageUrl("?pageNum=", pageNum, list.PageCount, list.RecorderCount);
    }

}
