﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

using Entity;
using BLL;
using Tool;

public partial class Admin_System_UserList : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
        {
            if (Request.QueryString["deptID"] == null || Request.QueryString["pageNum"] == null)
                BindUserList(-1, 1);
            else
            {
                int deptID = Convert.ToInt32(Request.QueryString["deptID"]);
                int pageNum = Convert.ToInt32(Request.QueryString["pageNum"]);
                BindUserList(deptID, pageNum);
            }
        }
    }

    private const int PAGE_SIZE = 20;
    private void BindUserList(int deptID, int pageNum)
    {
        drlDeptList.SelectedValue = deptID.ToString();
        PageList<User> pageList = new BLLAdmin().GetUserListByDeptID(deptID, pageNum, PAGE_SIZE);
        rpUserList.DataSource = pageList.RecorderList;
        rpUserList.DataBind();
        lblPageList.Text = StringHelper.MakePageUrl("?deptID="+deptID+"&pageNum=", pageNum, pageList.PageCount, pageList.RecorderCount);
    }

    protected void btnSearch_Click(object sender, EventArgs e)
    {
        int deptID = Convert.ToInt32(drlDeptList.SelectedValue);
        BindUserList(deptID, 1);
    }
}
