﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Test_PaperByManualSelectionDetail : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
            BindPaperInfo();
    }
    private int paperID
    {
        get
        {
            return Convert.ToInt32(Request.QueryString["paperID"]);
        }
    }

    private int testID
    {
        get
        {
            return Convert.ToInt32(Request.QueryString["testID"]);
        }
    }

    private void BindPaperInfo()
    {
        PaperByManualSelection paper = new BLLPaperByManuaSelection().GetPaper(testID,paperID);
        if (paper != null)
        {
            rptSubjectOfFillBlankList.DataSource = paper.FillBlankList;
            rptSubjectOfFillBlankList.DataBind();
            lblFillBlankListCount.Text = paper.FillBlankList.Count.ToString();
            if (paper.FillBlankList.Count > 0)
            {
                lblFillBlankScores.Text = paper.FillBlankList[0].Scores.ToString();
                lblFillBlankTotalScores.Text = (paper.FillBlankList[0].Scores * paper.FillBlankList.Count).ToString();
            }

            rptSubjectOfJudgeList.DataSource = paper.JudgeList;
            rptSubjectOfJudgeList.DataBind();
            lblJudgeListCount.Text = paper.JudgeList.Count.ToString();
            if (paper.JudgeList.Count > 0)
            {
                lblJudgeScores.Text = paper.JudgeList[0].Scores.ToString();
                lblJudgeTotalScores.Text = (paper.JudgeList[0].Scores * paper.JudgeList.Count).ToString();
            }

            rptSubjectOfSingleSelectionList.DataSource = paper.SingleSelectionList;
            rptSubjectOfSingleSelectionList.DataBind();
            lblSingleSelectionCount.Text = paper.SingleSelectionList.Count.ToString();
            if (paper.SingleSelectionList.Count > 0)
            {
                lblSingleSelectionScores.Text = paper.SingleSelectionList[0].Scores.ToString();
                lblSingleSelectionTotalScores.Text = (paper.SingleSelectionList[0].Scores * paper.SingleSelectionList.Count).ToString();
            }

            rptSubjectOfMultiSelectionList.DataSource = paper.MultiSelectionList;
            rptSubjectOfMultiSelectionList.DataBind();
            lblMultiSelectionCount.Text = paper.MultiSelectionList.Count.ToString();
            if (paper.MultiSelectionList.Count > 0)
            {
                lblMultiSelectionScores.Text = paper.MultiSelectionList[0].Scores.ToString();
                lblMultiSelectionTotalScores.Text = (paper.MultiSelectionList[0].Scores * paper.MultiSelectionList.Count).ToString();
            }

            rptSubjectOfSimpleAnswerList.DataSource = paper.SimpleAnswerList;
            rptSubjectOfSimpleAnswerList.DataBind();
            lblSimpleAnswerCount.Text = paper.SimpleAnswerList.Count.ToString();
            if (paper.SimpleAnswerList.Count > 0)
            {
                int totalScores = 0;
                foreach (SubjectOfSimpleAnswer subject in paper.SimpleAnswerList)
                {
                    totalScores += subject.Scores;
                }
                lblSimpleAnswerTotalScores.Text = totalScores.ToString();
            }
            lblPaperName.Text = paper.PaperName;
            lblPaperType.Text = paper.PaperType.DeptName;
            lblTotalScores.Text = (Convert.ToInt32(lblFillBlankTotalScores.Text)
                + Convert.ToInt32(lblJudgeTotalScores.Text)
                + Convert.ToInt32(lblSingleSelectionTotalScores.Text)
                + Convert.ToInt32(lblMultiSelectionTotalScores.Text)
                +Convert.ToInt32(lblSimpleAnswerTotalScores.Text)).ToString();
        }
    }
}
