﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Admin_Test_PaperByRandomSelectionDetail : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        RoleCheck.DenyLogin();
        if (!IsPostBack)
            BindPaperInfo();
    }
    private int paperID
    {
        get { return Helper.GetUrlParmValue("paperID"); }
    }

    private int testID
    {
        get { return Helper.GetUrlParmValue("testID"); }
    }

    private void BindPaperInfo()
    {
        if (paperID < 0)
            return;

        PaperByRandomSelection paper = new BLLPaperByRandomSelection().GetPaper(testID,paperID);
        if (paper != null)
        {
            rptSubjectOfJudgeList.DataSource = paper.JudgeList;
            rptSubjectOfJudgeList.DataBind();
            lblJudgeListCount.Text = paper.JudgeList.Count.ToString();
            if (paper.JudgeList.Count > 0)
            {
                lblJudgeScores.Text = paper.JudgeList[0].Scores.ToString();
                lblJudgeTotalScores.Text = (paper.JudgeList[0].Scores * paper.JudgeList.Count).ToString();
            }

            rptSubjectOfSingleSelectionList.DataSource = paper.SingleSelectionList;
            rptSubjectOfSingleSelectionList.DataBind();
            lblSingleSelectionCount.Text = paper.SingleSelectionList.Count.ToString();
            if (paper.SingleSelectionList.Count > 0)
            {
                lblSingleSelectionScores.Text = paper.SingleSelectionList[0].Scores.ToString();
                lblSingleSelectionTotalScores.Text = (paper.SingleSelectionList[0].Scores * paper.SingleSelectionList.Count).ToString();
            }

            rptSubjectOfMultiSelectionList.DataSource = paper.MultiSelectionList;
            rptSubjectOfMultiSelectionList.DataBind();
            lblMultiSelectionCount.Text = paper.MultiSelectionList.Count.ToString();
            if (paper.MultiSelectionList.Count > 0)
            {
                lblMultiSelectionScores.Text = paper.MultiSelectionList[0].Scores.ToString();
                lblMultiSelectionTotalScores.Text = (paper.MultiSelectionList[0].Scores * paper.MultiSelectionList.Count).ToString();
            }

            lblPaperName.Text = paper.PaperName;
            lblPaperType.Text = paper.PaperType.DeptName;

            lblTotalScores.Text = (Convert.ToInt32(lblJudgeTotalScores.Text)
            + Convert.ToInt32(lblSingleSelectionTotalScores.Text)
            + Convert.ToInt32(lblMultiSelectionTotalScores.Text)).ToString();
        }

    }
}
