﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

/// <summary>
/// Summary description for RoleCheck
/// </summary>
public static class RoleCheck
{

    private const string ADMIN_ROLE = "管理员";
    public static bool IsAdmin()
    {
        Entity.User user=SessionClass.GetLoginUser();
        if (user != null)
        {
            foreach (string right in user.RightList)
            {
                if(ADMIN_ROLE.Equals(right.Trim()))
                    return true;
            }
        }

        return false;
    }

    /// <summary>
    /// 拒绝非管理员用户的登录，拒绝后将跳转到登陆页面
    /// </summary>
    public static void DenyLogin()
    {
        if (!IsAdmin())
            HttpContext.Current.Response.Redirect(string.Format("~/LoginSystem.aspx?errorMsg={0}","您的权限不是管理员，无法访问该页面！（也有可能是登录超时，请重新登录）"));
    }
}
