﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using BLL;

public partial class LoginSystem : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            txtUserID.Focus();
            form1.DefaultButton = "btnLogin";

            if(!string.IsNullOrEmpty(errorMsg))
                Response.Write(errorMsg);

        }
    }

    private string errorMsg
    {
        get
        {
            string str= Request.QueryString["errorMsg"];
            if (!string.IsNullOrEmpty(str))
                str = string.Format("<p style='color:red'>{0}</p>", str);
            return str;
        }
    }

    protected void btnLogin_Click(object sender, EventArgs e)
    {

        Entity.User loginUser = new BLLUser().CheckLogin(txtUserID.Text, txtUserPwd.Text);

        if (null == loginUser)
        {
            lblMsg.Text = "账号或者密码错误，请重新输入！";
            txtUserPwd.Focus();
            return;
        }

        if (loginUser.Locked)
        {
            lblMsg.Text = "账号已锁定，请联系管理员！";
            txtUserPwd.Focus();
            return;
        }

        ////验证通过
        SessionClass.SetLoinUser(loginUser);

        FormsAuthentication.SetAuthCookie(loginUser.UserID,false);

        string returnUrl = FormsAuthentication.GetRedirectUrl(loginUser.UserID, false);
        if (returnUrl.Equals(FormsAuthentication.DefaultUrl))
        {
            if (RoleCheck.IsAdmin())
                returnUrl = "~/Admin/Default.aspx";
            else
                returnUrl = "~/Tester/Default.aspx";

        }

        Response.Redirect(returnUrl);
    }
    protected void btnRegister_Click(object sender, EventArgs e)
    {
        Response.Redirect("~/Register/Register.aspx");
    }
}
