﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Collections.Generic;

using Entity;
using BLL;

public partial class Register_Register : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            txtUserID.Focus();
            txtGraduateDate.Text = DateTime.Now.Year + "-07-01";
        }
    }
    protected void btnRegister_Click(object sender, EventArgs e)
    {
        Entity.User user = new User();
        user.UserID = txtUserID.Text;
        user.UserPwd = txtPassword.Text;
        user.Name = txtName.Text;
        user.Sex = (Sex)Convert.ToInt32(rblSex.SelectedValue);
        user.BirthDay = Convert.ToDateTime(txtBirthday.Text);
        user.Hometown = txtHometown.Text;
        user.School = txtSchool.Text;
        user.Major = txtMajor.Text;
        user.StudyExprience = drlStudyExprience.SelectedItem.Text;
        user.GraduateDate = Convert.ToDateTime(txtGraduateDate.Text);
        user.Telephone = txtTelephone.Text;
        user.Email = txtEmail.Text;

        //其他信息
        user.Department.DeptID = 8;
        List<string> right = new List<string>();
        right.Add("考试人员");
        user.RightList = right;
        user.Locked = false;

        int returnValue = new BLLUser().Register(user);
        if (returnValue == -1)
            lblMsg.Text = "账号" + user.UserID + "已存在！";
        else
            Response.Redirect("~/LoginSystem.aspx");
    }
}
