﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Entity;
using BLL;

public partial class Tester_DoTest : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            CheckRecorder();
            BindTestInfo();
            new BLLTestRecorder().ModifyBeginTest(TestID, SessionClass.GetLoginUser().UserID, DateTime.Now);
            Label1.Text = DateTime.Now.ToString();
        }
    }

    private void CheckRecorder()
    {
        BLLTestRecorder bllRecoder = new BLLTestRecorder();
        TestRecorder recorder = bllRecoder.GetTestRecorderListBy(TestID, SessionClass.GetLoginUser().UserID);
        if (null == recorder)
            Response.Redirect("msg.aspx?msg='考试不存在！'");

        if (recorder.Test.HasUnable)
        {
            Response.Redirect("msg.aspx?msg='这次考试的日期已过！'");
        }

        if (recorder.Test.BeforeEnable)
        {
            Response.Redirect("msg.aspx?msg='这次考试的日期未到！'");
        }

        if (recorder.HasTested)
        {
            Response.Redirect("msg.aspx?msg='你已经参加过该次考试了！'");
        }
    }

    protected int PaperID=0;

    protected string TestID
    {
        get
        {
            try
            {
                return Request.QueryString["testID"].ToString();
            }
            catch
            {
                return string.Empty;
            }
        }
    }

    private void BindTestInfo()
    {
        BLLTest bllTest = new BLLTest();
        Test test = bllTest.GetTestByID(TestID);
        hdfTestID.Value = TestID;
        PaperID = test.Paper.PaperID;
        lblTestName.Text = test.TestName;
        lblNeededMinutes.Text = test.NeededMinutes.ToString();

        int hours = test.NeededMinutes / 60;
        int minutes = test.NeededMinutes % 60;
        TimeSpan ts = new TimeSpan(hours,minutes, 10);//延长10秒

        DateTime now = DateTime.Now;
        ViewState["endTime"] = now.Add(ts);
        ViewState["autoSaveInterval"] = test.AutoSaveInterval;

        Timer2.Interval = 60000 * test.AutoSaveInterval;

        lblTimeLeft.Text = string.Format("{0}小时{1}分钟{2}秒", ts.Hours, ts.Minutes, ts.Seconds);
        lblAutoSaveMinutes.Text = test.AutoSaveInterval.ToString();

        Timer1.Enabled = true;
        Timer2.Enabled = true;
    }
    
    //关键方法：计时器
    protected void Timer1_Tick(object sender, EventArgs e)
    {
        this.Application.Lock();
        Label1.Text = DateTime.Now.ToString();
        DateTime endTime = Convert.ToDateTime(ViewState["endTime"]);
        DateTime now = DateTime.Now;       

        if (now.CompareTo(endTime)>=0)//时间已到
        {
            
            btnSaveAnswer.Enabled = false;
            btnSubmitTest.Enabled = false;
            Timer1.Enabled = false;
            Timer2.Enabled = false;
            new BLLTestRecorder().AutoSubmitTest(hdfTestID.Value, SessionClass.GetLoginUser().UserID,txtTesterAnswer.Text,DateTime.Now);
            lblTimeLeft.Text = "时间已到，系统已自动交卷！";
            btnSubmitTest.Text = "已自动提交";

            SessionClass.SetAlertMsg("时间已到，系统已自动交卷！");
            Response.Redirect("AlertAndClosePage.aspx");
        }

        TimeSpan ts = endTime.Subtract(now);
        lblTimeLeft.Text = string.Format("{0}小时{1}分钟{2}秒", ts.Hours, ts.Minutes, ts.Seconds);
        this.Application.UnLock();

    }

    //自动保存答案
    protected void Timer2_Tick(object sender, EventArgs e)
    {
        Label2.Text = "自动保存答案...(" + DateTime.Now.ToString() + ")";
        new BLLTestRecorder().AutoSaveAnswer(hdfTestID.Value, SessionClass.GetLoginUser().UserID, txtTesterAnswer.Text);
        Label2.Text = "自动保存答案.("+DateTime.Now.ToString()+")";
    }

    protected void btnSubmitTest_Click(object sender, EventArgs e)
    {
        try
        {
            new BLLTestRecorder().SubmitTest(hdfTestID.Value, SessionClass.GetLoginUser().UserID, txtTesterAnswer.Text, DateTime.Now);
            Label3.Text="提交成功！";
            btnSaveAnswer.Enabled = false;
            btnSubmitTest.Enabled = false;
            Timer1.Enabled = false;
            Timer2.Enabled = false;

            SessionClass.SetAlertMsg("交卷成功！");
            Response.Redirect("AlertAndClosePage.aspx");
        }
        catch(Exception ex)
        {
            Label3.Text="提交失败！"+ex.Message;
        }
    }
    protected void btnSaveAnswer_Click(object sender, EventArgs e)
    {
        try
        {
            new BLLTestRecorder().SaveAnswer(hdfTestID.Value, SessionClass.GetLoginUser().UserID, txtTesterAnswer.Text);
            Label3.Text = "保存成功！";
        }
        catch (Exception ex)
        {
            Label3.Text="保存失败!" + ex.Message;
        }
    }
}
