﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Student.aspx.cs" Inherits="Student" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <style type="text/css">
     html
     {
        background-color:silver;
     }
     .tabs
     {
        position:relative;
        top:1px;
        left:10px;
     }
     .tab
     {
        border:solid 1px black;
        background-color:#eeeeee;
        padding:2px 10px;
     }
     .selectedTab
     {
        background-color:white;
        border-bottom:solid 1px white;
     }
     .tabContents
     {
        border:solid 1px black;
        padding:10px;
        background-color:white;
     }
     .td1
     {
        width:75px;
     }

    </style>
    <title>无标题页</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
     <asp:Menu ID="Menu1" Orientation="Horizontal" StaticMenuItemStyle-CssClass="tab" StaticSelectedStyle-CssClass="selectedTab" CssClass="tabs" runat="server" OnMenuItemClick="Menu1_MenuItemClick">
      <Items>
       <asp:MenuItem Text="个人信息" Value="0" Selected="true" />
       <asp:MenuItem Text="修改密码" Value="1" />
       <asp:MenuItem Text="所选课程" Value="2" />
       <asp:MenuItem Text="选课操作" Value="3" />
       <asp:MenuItem Text="查询成绩" Value="4" />
      </Items>
     </asp:Menu>
     
     <div class="tabContents">
      <asp:MultiView ID="MultiView1" ActiveViewIndex="0" runat="server">
       <asp:View ID="View1" runat="server">
        <div>
         <center>
          <br />
          <h1>个人信息</h1>
          <asp:DetailsView ID="detailsView1" runat="server" DataSourceID="srcGetStudent" AutoGenerateRows="False">
              <Fields>
                  <asp:BoundField DataField="Sid" HeaderText="学号" ReadOnly="True" SortExpression="Sid" />
                  <asp:BoundField DataField="Sname" HeaderText="姓名" ReadOnly="True" SortExpression="Sname" />
                  <asp:BoundField DataField="Ssex" HeaderText="性别" ReadOnly="True" SortExpression="Ssex" />
                  <asp:BoundField DataField="Snati" HeaderText="民族" ReadOnly="True" SortExpression="Snati" />
                  <asp:BoundField DataField="Sbir" HeaderText="出生日期" ReadOnly="True" SortExpression="Sbir" />
                  <asp:BoundField DataField="Sclaid" HeaderText="班级编号" ReadOnly="True" SortExpression="Sclaid" />
                  <asp:BoundField DataField="Stime" HeaderText="入学时间" ReadOnly="True" SortExpression="Stime" />
                  <asp:BoundField DataField="Saddr" HeaderText="家庭住址" ReadOnly="True" SortExpression="Saddr" />
                  <asp:BoundField DataField="Selse" HeaderText="备注" ReadOnly="True" SortExpression="Selse" />
              </Fields>
          </asp:DetailsView>
          <asp:SqlDataSource ID="srcGetStudent" runat="server" ConnectionString="<%$ ConnectionStrings:DataBaseConnectionString %>" SelectCommand="SELECT [Sid], [Sname], [Ssex], [Snati], [Sbir], [Sclaid], [Stime], [Saddr], [Selse] FROM [tabstu] WHERE ([Sid] = @Sid)" DataSourceMode="DataReader">
              <SelectParameters>
                  <asp:SessionParameter Name="Sid" SessionField="UserID" Type="String" />
              </SelectParameters>
          </asp:SqlDataSource>
         </center>
        </div>
       </asp:View>
       <asp:View ID="View2" runat="server">
        <div>
         <center>
          <br />
          <h1>修改密码</h1>
          <table>
           <tr>
            <td>
             <asp:Label ID="lblUserID" runat="server" Text="用户名：" AssociatedControlID="txtUserID" />
            </td>
            <td>
             <asp:TextBox ID="txtUserID" runat="server" Width="120px" ReadOnly="true"/>
            </td>
           </tr>
           <tr>
            <td>
             <asp:Label ID="lblPassword" runat="server" Text="密码：" AssociatedControlID="txtPassword" />
            </td>
            <td>
             <asp:TextBox ID="txtPassword" runat="server" TextMode="Password" Width="120px" />
             <asp:RequiredFieldValidator ID="reqPassword" runat="server" Text="" ErrorMessage="请输入密码!" Display="None" ControlToValidate="txtPassword" />
            </td>
           </tr>
           <tr>
            <td>
             <asp:Label ID="lblSurePassword" runat="server" Text="确认密码：" AssociatedControlID="txtSurePassword" />
            </td>
            <td>
             <asp:TextBox ID="txtSurePassword" runat="server" TextMode="Password" Width="120px" />
             <asp:RequiredFieldValidator ID="reqSurePassword" runat="server" Text="" ErrorMessage="请再次输入密码以保证密码的一致性!" Display="None" ControlToValidate="txtSurePassword" />
             <asp:CompareValidator ID="comPassword" runat="server" Text="" ErrorMessage="对不起，您两次输入的密码不一致!" Display="None" ControlToCompare="txtPassword" ControlToValidate="txtSurePassword" Operator="Equal"/>
            </td>
           </tr>
          </table>
          <br />
          <table>
           <tr>
            <td class="td1">
             <asp:Button ID="btnOk" runat="server" Text="确定" OnClick="btnOk_Click" />
            </td>
            <td class="td1">
             <asp:Button ID="btnCancel" runat="server" Text="取消" CausesValidation="false" OnClick="btnCancel_Click" />
            </td>
           </tr>
          </table>
          <asp:ValidationSummary ID="validatorSum1" runat="server" ShowMessageBox="true" ShowSummary="false" />
         </center>
        </div>
       </asp:View>
       <asp:View ID="View3" runat="server">
        <div>
         <center>
          <br />
          <h1>选课信息</h1>
          您所选课程的详细信息如下:
          <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataSourceID="srcGetCrous">
           <EmptyDataTemplate>
            您还没有选择任何课程!
           </EmptyDataTemplate>
              <Columns>
                  <asp:BoundField DataField="Crname" HeaderText="课程名称" ReadOnly="True" SortExpression="Crname" />
                  <asp:BoundField DataField="Crper" HeaderText="课程学时" ReadOnly="True" SortExpression="Crper" />
                  <asp:BoundField DataField="Crcre" HeaderText="课程学分" ReadOnly="True" SortExpression="Crcre" />
                  <asp:BoundField DataField="Tname" HeaderText="教师姓名" ReadOnly="True" SortExpression="Tname" />
              </Columns>
          </asp:GridView>
          <asp:SqlDataSource ID="srcGetCrous" runat="server" ConnectionString="<%$ ConnectionStrings:DataBaseConnectionString %>"
           SelectCommand="select tabCrous.Crname,tabCrous.Crper,tabCrous.Crcre,tabtea.Tname from tabCrous,tabtea,tabstu,tabstu_cour,tabtea_cour where tabstu_cour.sid=@Sid and tabstu_cour.crid=tabCrous.crid and tabtea_cour.Tid=tabtea.Tid and tabstu_cour.crid=tabtea_cour.crid group by tabCrous.Crname,tabCrous.Crper,tabCrous.Crcre,tabtea.Tname" DataSourceMode="DataReader">
            <SelectParameters>
             <asp:SessionParameter Name="Sid" SessionField="UserID" />
            </SelectParameters>
           </asp:SqlDataSource>
         </center>
        </div>
       </asp:View>
       <asp:View ID="View4" runat="server">
        <div>
         <center>
          <br />
          <h1>选可操作</h1>
          以下是您可以选择的课程，最多可以选择3门课，单击“确定”提交信息。
          <br />
          <br />
          <table border="1">
            <tr>
             <td>
              <asp:CheckBoxList ID="checkBoxSelectCourse" runat="server" RepeatColumns="5" DataSourceID="srcGetCourse" RepeatDirection="Horizontal" DataTextField="Crname" DataValueField="Crid" />
             </td>
            </tr>
          </table>
          <br />
          <table>
           <tr>
            <td class="td1">
             <asp:Button ID="btnSubmit" runat="server" Text="确定" OnClick="btnSubmit_Click" />
            </td>
            <td class="td1">
             <asp:Button ID="btnCalcelSubmit" runat="server" Text="取消" OnClick="btnCalcelSubmit_Click" />
            </td>
           </tr>
          </table>
         </center>
         <asp:SqlDataSource ID="srcGetCourse" runat="server" ConnectionString="<%$ ConnectionStrings:DataBaseConnectionString %>" SelectCommand="SELECT tabCrous.[Crid], tabCrous.[Crname] FROM [tabCrous], tabstu_cour where tabCrous.Crid not in 
(select tabstu_cour.Crid from tabstu_cour where tabstu_Cour.sid=@Sid)
group by tabCrous.[Crid], tabCrous.[Crname]" DataSourceMode="DataReader">
          <SelectParameters>
           <asp:SessionParameter Name="Sid" SessionField="UserID" />
          </SelectParameters>
         </asp:SqlDataSource>
        </div>
       </asp:View>
       <asp:View ID="View5" runat="server">
        <div>
         <center>
          <br />
          <h1>成绩查询</h1>
          下面是你所选各个课程的成绩：
          <br />
          <br />
          <asp:GridView ID="GridView2" runat="server" DataSourceID="srcGetScore" AutoGenerateColumns="False">
           <EmptyDataTemplate>
            现在还没有录入任何成绩，请耐心等待!
           </EmptyDataTemplate>
              <Columns>
                  <asp:BoundField DataField="sname" HeaderText="学生姓名" ReadOnly="True" SortExpression="sname" />
                  <asp:BoundField DataField="Crname" HeaderText="课程名称" ReadOnly="True" SortExpression="Crname" />
                  <asp:BoundField DataField="Score" HeaderText="课程成绩" ReadOnly="True" SortExpression="Score" />
              </Columns>
          </asp:GridView>
          <asp:SqlDataSource ID="srcGetScore" runat="server" DataSourceMode="DataReader" ConnectionString="<%$ ConnectionStrings:DataBaseConnectionString %>" SelectCommand="select tabstu.sname,tabCrous.Crname,tabstu_cour.Score from tabstu,tabCrous,tabstu_cour where tabstu_cour.Sid=@Sid and tabstu_cour.Sid=tabstu.Sid and tabstu_cour.Crid=tabCrous.Crid" >
           <SelectParameters>
            <asp:SessionParameter Name="Sid" SessionField="UserID" />
           </SelectParameters>
          </asp:SqlDataSource>
         </center>
        </div>
       </asp:View>
      </asp:MultiView>
     </div>
    </div>
    </form>
</body>
</html>
