﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
//该源码下载自www.51aspx.com(５１ａspｘ．ｃｏｍ)

public partial class checkcode : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CreateCheckCodeImage(GenerateCheckCode());
    }
    private string GenerateCheckCode()//生成数字及大小写字母的验证码
    {
        int number;
        char code;
        string checkCode = String.Empty;
        System.Random random = new Random();
        for (int i = 0; i < 4; i++)//定义验证码长度
        {
            number = random.Next();//返回一个小于制定最大数的非负随机数
            if (number%2==0)
            {
                if (number % 4 == 0)
                    code = (char)('0' + (char)(number % 10));
                else
                    code = (char)('A' + (char)(number % 26));
            }
            else
            {
                if (number % 4 == 0)
                    code = (char)('0' + (char)(number % 10));
                else
                    code = (char)('a' + (char)(number % 26));
            
            }
            checkCode += code.ToString();
        }
        Response.Cookies.Add(new HttpCookie("CheckCode",checkCode));
        return checkCode;
    }
    private void CreateCheckCodeImage(string checkCode)//画图像及线条
    {
        if (checkCode == null || checkCode.Trim() == String.Empty)//如果传入的参数为空
            return;//则返回
        System.Drawing.Bitmap image = new Bitmap((int)Math.Ceiling((checkCode.Length * 14.5)), 22);//Bitmap(长度,高度)
        Graphics g = Graphics.FromImage(image);//得到长度及高度的值
        try
        {
            Random random = new Random(); //生成随机生成器
            g.Clear(Color.White);  //清空图片背景色
            //画图片的背景噪音线
            for(int i=0;i<4;i++)
            {
                int x1 = random.Next(image.Width);
                int x2 = random.Next(image.Width);
                int y1 = random.Next(image.Height);
                int y2 = random.Next(image.Height);
                g.DrawLine(new Pen(Color.Black), x1, y1, x2, y2);//DrawLine颜色
            }
            Font font = new Font("Arial", 12, (System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Italic));
            System.Drawing.Drawing2D.LinearGradientBrush brush = new System.Drawing.Drawing2D.LinearGradientBrush(new Rectangle(0, 0,image.Width, image.Height), Color.Blue, Color.DarkRed, 1.2f, true);
            g.DrawString(checkCode, font, brush, 2, 2);
            //画图片的前景噪音点
            for (int i = 0; i < 100; i++)
            {
                int x = random.Next(image.Width);
                int y = random.Next(image.Height);
                image.SetPixel(x,y,Color.FromArgb(random.Next()));//划点

            }
            //画图片的边框线
            g.DrawRectangle(new Pen(Color.Silver), 0, 0, image.Width - 1, image.Height - 1);
            System.IO.MemoryStream ms = new System.IO.MemoryStream();//创建内存流
            image.Save(ms, System.Drawing.Imaging.ImageFormat.Gif);//指定图像保存格式
            Response.ClearContent();//清空缓冲区内容
            Response.ContentType = "image/Gif";//输出图像格式
            Response.BinaryWrite(ms.ToArray());//写入HTTP输出流
        }
        finally
        {
            g.Dispose();//释放资源
            image.Dispose();
        }

    }
}
