﻿//<tunynetcopyright>
//--------------------------------------------------------------
//<version>v0.5</verion>
//<createdate>2017-01-20</createdate>
//<author>wanglei</author>
//<email>wanglei@tunynet.com</email>
//<log date="2017-01-20" version="0.5">新建</log>
//--------------------------------------------------------------
//</tunynetcopyright>

using Autofac;
using Newtonsoft.Json;
using PetaPoco;
using System;
using System.Collections.Generic;
using System.Linq;
using Tunynet.Caching;
using Tunynet.Repositories;

namespace Tunynet.CMS
{
    /// <summary>
    /// 栏目实体
    /// </summary>
    [TableName("tn_ContentCategories")]
    [PrimaryKey("CategoryId", autoIncrement = true)]
    [CacheSetting(false)]
    [Serializable]
    public class ContentCategory : SerializablePropertiesBase, IEntity
    {
        /// <summary>
        ///
        /// </summary>
        public static ContentCategory New()
        {
            ContentCategory contentCategorie = new ContentCategory()
            {
                CategoryName = string.Empty,
                Description = string.Empty,
                ParentIdList = "",
                DateCreated = DateTime.Now,
                ContentModelKeys = string.Empty,
                ParentId = 0
            };
            return contentCategorie;
        }

        #region 需持久化属性

        /// <summary>
        ///主键
        /// </summary>
        public int CategoryId { get; set; }

        /// <summary>
        ///栏目名称
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        ///栏目描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        ///ParentId
        /// </summary>
        public int ParentId { get; set; }

        /// <summary>
        ///所有父级CatetoryId
        /// </summary>
        public string ParentIdList { get; set; }

        /// <summary>
        ///子栏目数目
        /// </summary>
        public int ChildCount { get; set; }

        /// <summary>
        ///深度(从0开始)
        /// </summary>
        public int Depth { get; set; }

        /// <summary>
        ///是否启用
        /// </summary>
        public bool IsEnabled { get; set; }

        /// <summary>
        ///内容计数
        /// </summary>
        public int ContentCount { get; set; }

        /// <summary>
        ///创建日期
        /// </summary>
        public DateTime DateCreated { get; set; }

        /// <summary>
        ///内容模型Key集合(多个用英文逗号隔开)
        /// </summary>
        public string ContentModelKeys { get; set; }

        /// <summary>
        ///流程定义Id
        /// </summary>
        public long ProcessDefinitionId { get; set; }

        /// <summary>
        ///排列顺序，默认和CategoryId一致
        /// </summary>
        public int DisplayOrder { get; set; }

        #endregion 需持久化属性

        /// <summary>
        /// 获取内容模型集合
        /// </summary>
        [Ignore]
        [JsonIgnore]
        public IEnumerable<ContentModel> ContentTypes
        {
            get
            {
                var keys = this.ContentModelKeys.Split(',');
                //获取内容模型的集合.Where(n=>n.IsEnabled)
                IEnumerable<ContentModel> contentmodel = new Repository<ContentModel>().GetAll();
                return contentmodel.Where(n => keys.Contains(n.ModelKey));
            }
        }

        /// <summary>
        /// 是否栏目列表显示
        /// </summary>
        [Ignore]
        public bool IsListDisplay
        {
            get
            {
                return GetExtendedProperty<bool>("IsListDisplay");
            }
            set
            {
                SetExtendedProperty("IsListDisplay", value);
            }
        }

        /// <summary>
        /// 获取所有子栏目(非即时更新)
        /// </summary>
        [Ignore]
        [JsonIgnore]
        public IEnumerable<ContentCategory> Children
        {
            get
            {
                if (ChildCount > 0)
                    return new Repository<ContentCategory>().GetAll("DisplayOrder").Where(x => x.ParentId == this.CategoryId);
                else
                    return new List<ContentCategory>();
            }
        }

        #region IEntity 成员

        object IEntity.EntityId { get { return this.CategoryId; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}