﻿//<tunynetcopyright>
//--------------------------------------------------------------
//<version>v0.6</verion>
//<createdate>2017-01-20</createdate>
//<author>wanglei</author>
//<email>wanglei@tunynet.com</email>
//<log date="2017-01-20" version="0.5">新建</log>
//<log date="2017-4-1" version="0.6">修改 GetContentModelsByContentModeKey</log>
//--------------------------------------------------------------
//</tunynetcopyright>

using System.Collections.Generic;
using System.Linq;
using Tunynet.Repositories;

namespace Tunynet.CMS
{
    /// <summary>
    /// 内容模型业务逻辑
    /// </summary>
    public class ContentModelService
    {
        private IRepository<ContentModel> contentModelRepository;
        private IRepository<ContentModelAdditionalFields> contentModelAdditionalRepository;

        /// <summary>
        /// 构造器
        /// </summary>
        public ContentModelService(IRepository<ContentModel> contentModelRepository, IRepository<ContentModelAdditionalFields> contentModelAdditionalRepository)
        {
            this.contentModelRepository = contentModelRepository;
            this.contentModelAdditionalRepository = contentModelAdditionalRepository;
        }

        /// <summary>
        /// 获取内容模型
        /// </summary>
        /// <param name="modelId"></param>
        /// <returns></returns>
        public ContentModel Get(long modelId)
        {
            return contentModelRepository.Get(modelId);
        }

        /// <summary>
        /// 获取所有内容模型
        /// </summary>
        /// <returns></returns>
        public IEnumerable<ContentModel> GetAll()
        {
            return contentModelRepository.GetAll();
        }

        /// <summary>
        /// 获取内容模型的所有字段
        /// </summary>
        /// <param name="modelId"></param>
        /// <returns></returns>
        public IEnumerable<ContentModelAdditionalFields> GetColumnsByContentModelId(int modelId)
        {
            return contentModelAdditionalRepository.GetAll().Where(n => n.ModelId == modelId).ToList();
        }

        /// <summary>
        /// 通过ContentModelKey来获取ContentModel
        /// </summary>
        /// <param name="contentModelKey">内容模型的Key</param>
        /// <returns></returns>
        public ContentModel GetContentModelsByContentModeKey(string contentModelKey)
        {
            return contentModelRepository.GetAll().FirstOrDefault(n => n.ModelKey == contentModelKey);
        }
    }
}