﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 每日计数实体
    /// </summary>
    [TableName("tn_CountsPerDay")]
    [PrimaryKey("Id", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class CountPerDayEntity : IEntity
    {
        #region 需持久化属性

        /// <summary>
        ///id
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        ///拥有者id
        /// </summary>
        public long OwnerId { get; set; }

        /// <summary>
        ///租户类型Id
        /// </summary>
        public string TenantTypeId { get; set; }

        /// <summary>
        ///计数对象id
        /// </summary>
        public long ObjectId { get; set; }

        /// <summary>
        ///统计日期的年份
        /// </summary>
        public int ReferenceYear { get; set; }

        /// <summary>
        ///统计日期的月份
        /// </summary>
        public int ReferenceMonth { get; set; }

        /// <summary>
        ///统计日期的天
        /// </summary>
        public int ReferenceDay { get; set; }

        /// <summary>
        ///当天计数
        /// </summary>
        public int StatisticsCount { get; set; }

        /// <summary>
        ///计数类型
        /// </summary>
        public string CountType { get; set; }

        #endregion 需持久化属性

        /// <summary>
        /// 统计日期
        /// </summary>
        [Ignore]
        public DateTime ReferenceDate
        {
            get
            {
                return new DateTime(ReferenceYear, ReferenceMonth, ReferenceDay);
            }
        }

        #region IEntity 成员

        object IEntity.EntityId { get { return this.Id; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}