﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

namespace Tunynet.Common
{
    /// <summary>
    /// 计数类型
    /// </summary>
    public class CountTypes
    {
        #region Instance

        private static CountTypes _instance = new CountTypes();

        /// <summary>
        /// 获取单例
        /// </summary>
        /// <returns></returns>
        public static CountTypes Instance()
        {
            return _instance;
        }

        private CountTypes()
        { }

        #endregion Instance

        /// <summary>
        /// 浏览计数
        /// </summary>
        /// <returns></returns>
        public string HitTimes()
        {
            return "HitTimes";
        }

        /// <summary>
        /// 登录计数
        /// </summary>
        /// <returns></returns>
        public string LoginTimes()
        {
            return "LoginTimes";
        }

        /// <summary>
        /// 下载计数
        /// </summary>
        /// <returns></returns>
        public string DownloadCount()
        {
            return "DownloadCount";
        }

        /// <summary>
        /// 评论数
        /// </summary>
        /// <returns></returns>
        public string CommentCount()
        {
            return "CommentCount";
        }

        /// <summary>
        /// 威望数
        /// </summary>
        /// <returns></returns>
        public string ReputationPointsCounts()
        {
            return "ReputationPointsCounts";
        }

        /// <summary>
        /// 站点所有内容计数
        /// </summary>
        /// <returns></returns>
        public string AllItems()
        {
            return "AllItems";
        }

        /// <summary>
        /// 搜索词计数
        /// </summary>
        /// <returns></returns>
        public string SearchWordCounts()
        {
            return "SearchWordCounts";
        }

        /// <summary>
        /// 对外显示的内容项数量
        /// </summary>
        /// <remarks>
        /// 这个主要用于标签和类别 更改审核状态时前台的内容数需要变化 实体内自带的Itemcount在后台用 不需要变化
        /// </remarks>
        /// <returns></returns>
        public string ItemCount()
        {
            return "ItemCount";
        }

        /// <summary>
        /// 对外显示的回答数
        /// </summary>
        /// <remarks>
        /// 这个用于问题的回答数 更改审核状态时前台的内容数需要变化 实体内自带的AnswerCount在后台用 不需要变化
        /// </remarks>
        /// <returns></returns>
        public string AnswerCount()
        {
            return "AnswerCount";
        }
    }
}