﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System;

namespace Tunynet.Post
{
    /// <summary>
    /// 特殊帖子相关信息
    /// </summary>
    public interface ISpecialThreadUrlGetter
    {
        /// <summary>
        /// 帖子类型
        /// </summary>
        ThreadType ThreadType { get; }


        /// <summary>
        /// 获取特殊帖子的信息
        /// </summary>
        /// <param name="associateId"></param>
        /// <returns></returns>
        ThreadObjectData GetThreadObject(long associateId);
    }

    /// <summary>
    /// 贴子对象数据
    /// </summary>
    public class ThreadObjectData
    {
        /// <summary>
        /// 主键Id
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        /// 发帖人Id
        /// </summary>
        public long UserId { get; set; }

        /// <summary>
        /// 投票参与人数
        /// </summary>
        public int  AttendCount { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime StartTime { get; set; }
    }
}