﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Post
{
    /// <summary>
    /// 贴吧仓储接口
    /// </summary>
    public interface ISectionRepository : IRepository<Section>
    {
        /// <summary>
        /// 获取拥有者的贴吧列表
        /// </summary>
        /// <param name="tenantTypeId">租户类型Id</param>
        /// <param name="userId">吧主UserId</param>
        /// <returns>贴吧列表</returns>
        IEnumerable<Section> GetsByUserId(string tenantTypeId, long userId);

        /// <summary>
        /// 获取贴吧分页集合
        /// </summary>
        /// <param name="tenantTypeId">租户id</param>
        /// <param name="categoryId">分类id</param>
        /// <param name="userId">吧主id</param>
        /// <param name="isEnabled">是否启用（前台只显示启用贴吧）</param>
        /// <param name="keyword">搜索关键词（名称或描述）</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="pageIndex">页码</param>
        /// <returns></returns>
        PagingDataSet<Section> Gets(string tenantTypeId, long? categoryId = null, long? userId = null, bool? isEnabled = null, string keyword = "", int pageSize = 20, int pageIndex = 1);

        /// <summary>
        ///  删除用户创建的贴吧
        /// </summary>
        /// <remarks>
        /// 供用户删除时处理用户相关信息时调用
        /// </remarks>
        /// <param name="userId">UserId</param>
        /// <returns></returns>
        int DeleteUserSections(long userId);
    }
}