﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Tunynet.Repositories;

namespace Tunynet.Settings
{
    /// <summary>
    /// 设置管理器
    /// </summary>
    /// <typeparam name="TSettingsEntity"></typeparam>
    public class SettingManager<TSettingsEntity> : ISettingsManager<TSettingsEntity> where TSettingsEntity : class, IEntity, new()
    {
        private ISettingsRepository<TSettingsEntity> repository = new SettingsRepository<TSettingsEntity>();

        /// <summary>
        /// 获取设置
        /// </summary>
        /// <returns></returns>
        public TSettingsEntity Get()
        {
            return repository.Get();
        }

        /// <summary>
        /// 保存设置
        /// </summary>
        /// <param name="settings"></param>
        public void Save(TSettingsEntity settings)
        {
            repository.Save(settings);
        }
    }
}