﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.ComponentModel.DataAnnotations;

namespace Tunynet.Common
{
    /// <summary>
    /// 多租户服务标识
    /// </summary>
    public class MultiTenantServiceKeys
    {
        #region Instance

        private static volatile MultiTenantServiceKeys _instance = null;
        private static readonly object lockObject = new object();

        /// <summary>
        /// 创建单例
        /// </summary>
        /// <returns></returns>
        public static MultiTenantServiceKeys Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new MultiTenantServiceKeys();
                    }
                }
            }
            return _instance;
        }

        private MultiTenantServiceKeys()
        { }

        #endregion Instance

        /// <summary>
        /// 计数
        /// </summary>
        /// <returns></returns>
        [Display(Name = "计数")]
        public string Count()
        {
            return "Count";
        }

        /// <summary>
        /// 评论
        /// </summary>
        /// <returns></returns>
        [Display(Name = "评论")]
        public string Comment()
        {
            return "Comment";
        }

        /// <summary>
        /// 标签
        /// </summary>
        /// <returns></returns>
        [Display(Name = "标签")]
        public string Tag()
        {
            return "Tag";
        }

        /// <summary>
        ///  推荐
        /// </summary>
        /// <returns></returns>
        [Display(Name = "推荐")]
        public string Recommend()
        {
            return "Recommend";
        }

        /// <summary>
        /// 顶踩
        /// </summary>
        /// <returns></returns>
        [Display(Name = "顶踩")]
        public string Attitude()
        {
            return "Attitude";
        }

        /// <summary>
        /// 附件
        /// </summary>
        /// <returns></returns>
        [Display(Name = "附件")]
        public string Attachment()
        {
            return "Attachment";
        }

        /// <summary>
        /// @用户
        /// </summary>
        /// <returns></returns>
        [Display(Name = "@用户")]
        public string AtUser()
        {
            return "AtUser";
        }

        /// <summary>
        /// 收藏
        /// </summary>
        /// <returns></returns>
        [Display(Name = "收藏")]
        public string Favorites()
        {
            return "Favorites";
        }

        /// <summary>
        /// 栏目管理员
        /// </summary>
        /// <returns></returns>
        [Display(Name = "栏目管理员")]
        public string CategoryManager()
        {
            return "CategoryManager";
        }

        /// <summary>
        /// 分类
        /// </summary>
        /// <returns></returns>
        [Display(Name = "分类")]
        public string Category()
        {
            return "Category";
        }

        /// <summary>
        /// 操作日志
        /// </summary>
        /// <returns></returns>
        [Display(Name = "操作日志")]
        public string OperationLog()
        {
            return "OperationLog";
        }

        /// <summary>
        /// 举报
        /// </summary>
        /// <returns></returns>
        [Display(Name = "举报")]
        public string ImpeachReport()
        {
            return "ImpeachReport";
        }
    }
}