﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 租户数据实体类
    /// </summary>
    [TableName("tn_TenantTypes")]
    [PrimaryKey("TenantTypeId", autoIncrement = false)]
    [CacheSetting(true)]
    [Serializable]
    public class TenantType : IEntity
    {
        /// <summary>
        /// 租户类型Id
        /// </summary>
        public string TenantTypeId { get; set; }

        /// <summary>
        /// 租户类型名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 类型
        /// </summary>
        public string ClassType { get; set; }

        #region IEntity 成员

        object IEntity.EntityId { get { return this.TenantTypeId; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}