﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;

namespace Tunynet.Common
{
    /// <summary>
    /// 租户类型业务逻辑类
    /// </summary>
    public class TenantTypeService
    {
        #region 构造器

        private ITenantTypeRepository tenantTypeRepository;

        /// <summary>
        /// 构造器
        /// </summary>
        public TenantTypeService()
            : this(new TenantTypeRepository())
        {
        }

        /// <summary>
        /// 构造器
        /// </summary>
        /// <param name="tenantTypeRepository">租户数据仓储接口</param>
        public TenantTypeService(ITenantTypeRepository tenantTypeRepository)
        {
            this.tenantTypeRepository = tenantTypeRepository;
        }

        #endregion 构造器

        /// <summary>
        /// 依据服务或应用获取租户类型
        /// </summary>
        /// <param name="serviceKey">服务标识</param>
        /// <returns>如未满足条件的TenantType则返回空集合</returns>
        public IEnumerable<TenantType> Gets(string serviceKey)
        {
            return tenantTypeRepository.Gets(serviceKey);
        }

        /// <summary>
        /// 依据tenantTypeId获取租户类型
        /// </summary>
        /// <param name="tenantTypeId">租户类型Id</param>
        /// <returns></returns>
        public TenantType Get(string tenantTypeId)
        {
            return tenantTypeRepository.Get(tenantTypeId);
        }
    }
}