﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    ///广告数据访问接口
    /// </summary>
    public interface IAdvertisingRepository : IRepository<Advertising>
    {
        /// <summary>
        /// 获取广告列表
        /// </summary>
        /// <param name="keyword">广告备注</param>
        /// <param name="positionId">广告位</param>
        /// <param name="status">广告状态</param>
        /// <param name="pageSize">每页记录数</param>
        /// <param name="pageIndex">当前页数</param>
        /// <returns></returns>
        PagingDataSet<Advertising> GetAdvertisingsForAdmin(string keyword, long? positionId, AdvertisingStatus? status, int pageSize, int pageIndex);

        /// <summary>
        /// 根据广告Id取所有的广告位
        /// </summary>
        /// <param name="advertisingId">广告Id</param>
        /// <returns></returns>
        IEnumerable<AdvertisingPosition> GetPositionsByAdvertisingId(long advertisingId);

        /// <summary>
        /// 获取广告统计数据
        /// </summary>
        /// <returns></returns>
        long GetAdvertisingCount();

        /// <summary>
        /// 清除广告的所有广告位
        /// </summary>
        /// <param name="advertisingId">广告Id</param>
        void ClearPositionsFromAdvertising(long advertisingId);

        /// <summary>
        /// 为广告批量设置广告位
        /// </summary>
        /// <param name="advertisingId">广告Id</param>
        /// <param name="positionIds">广告位Id集合</param>
        void AddPositionsToAdvertising(long advertisingId, IEnumerable<long> positionIds);

        /// <summary>
        /// 定期移除过期的广告
        /// </summary>
        void DeleteExpiredAdvertising();
    }
}