﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Newtonsoft.Json;
using PetaPoco;
using System;
using System.Collections.Generic;
using Tunynet.Caching;
using Tunynet.Utilities;

namespace Tunynet.Common
{
    /// <summary>
    /// 地区实体类
    /// </summary>
    [TableName("tn_Areas")]
    [PrimaryKey("AreaCode", autoIncrement = false)]
    [CacheSetting(true)]
    [Serializable]
    public class Area : IEntity
    {
        /// <summary>
        /// 新建实体时使用
        /// </summary>
        public static Area New()
        {
            Area area = new Area()
            {
                Name = string.Empty,
                PostCode = string.Empty
            };
            return area;
        }

        #region 需持久化属性

        /// <summary>
        ///地区编码
        /// </summary>
        public string AreaCode { get; set; }

        /// <summary>
        ///父级地区编码
        /// </summary>
        public string ParentCode { get; set; }

        /// <summary>
        ///地区名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        ///邮政编码
        /// </summary>
        public string PostCode { get; set; }

        /// <summary>
        ///排序序号
        /// </summary>
        public int DisplayOrder { get; set; }

        /// <summary>
        ///深度
        /// </summary>
        public int Depth { get; set; }

        /// <summary>
        ///子地区个数
        /// </summary>
        public int ChildCount { get; set; }

        #endregion 需持久化属性

        private List<Area> children;

        /// <summary>
        /// 子地区列表
        /// </summary>
        [Ignore]
        [JsonIgnore]
        public IEnumerable<Area> Children
        {
            get
            {
                if (this.children == null)
                    children = new List<Area>();
                return children.ToReadOnly();
            }
        }

        /// <summary>
        /// 添加子区域
        /// </summary>
        /// <param name="area"></param>
        public void AppendChild(Area area)
        {
            if (children == null)
                children = new List<Area>();

            children.Add(area);
        }

        #region IEntity 成员

        object IEntity.EntityId { get { return this.AreaCode; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}