﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Tunynet.Events;

namespace Tunynet.Attitude
{
    /// <summary>
    /// 顶踩事件
    /// </summary>
    public class SupportOpposeEventArgs : CommonEventArgs
    {
        /// <summary>
        /// 顶踩事件
        /// </summary>
        /// <param name="tenantTypeId"></param>
        /// <param name="userId"></param>
        /// <param name="firstTime"></param>
        /// <param name="eventOperationType"></param>
        public SupportOpposeEventArgs(string tenantTypeId, long userId, bool firstTime, string eventOperationType)
            : base(eventOperationType)
        {
            this.TenantTypeId = tenantTypeId;
            this.UserId = userId;
            this.FirstTime = firstTime;
        }

        /// <summary>
        /// 租户类型ID
        /// </summary>
        public string TenantTypeId { get; set; }

        /// <summary>
        /// 操作用户ID
        /// </summary>
        public long UserId { get; set; }

        /// <summary>
        /// 是否第一次顶或踩的操作，用于区别是否反向操作后又正向操作
        /// </summary>
        public bool FirstTime { get; set; }
    }
}