﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

namespace Tunynet.Common
{
    /// <summary>
    /// 举报相关Url获取器
    /// </summary>
    public interface IImpeachUrlGetter
    {
        /// <summary>
        /// 租户类型Id
        /// </summary>
        string TenantTypeId { get; }

        /// <summary>
        /// 获取被举报的对象实体
        /// </summary>
        /// <param name="reportObjectId">被举报相关对象Id</param>
        /// <returns></returns>
        ImpeachObject GetImpeachObject(long reportObjectId);
    }

    /// <summary>
    /// 对象实体
    /// </summary>
    public class ImpeachObject
    {
        /// <summary>
        /// 被举报内容详情地址
        /// </summary>
        public string DetailUrl { get; set; }

        /// <summary>
        /// 被举报内容的发布者用户名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 被举报内容的发布者用户Id
        /// </summary>
        public long UserId { get; set; }
    }
}