﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;

namespace Tunynet.Common
{
    /// <summary>
    /// 举报URL获取器工厂
    /// </summary>
    public static class ImpeachUrlGetterFactory
    {
        /// <summary>
        /// 依据tenantTypeId获取IImpeachUrlGetter
        /// </summary>
        /// <returns></returns>
        public static IImpeachUrlGetter Get(string tenantTypeId)
        {
            return DIContainer.Resolve<IEnumerable<IImpeachUrlGetter>>().Where(g => g.TenantTypeId.Equals(tenantTypeId, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
        }
    }
}