﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using System;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户举报的数据访问层接口
    /// </summary>
    public interface IImpeachReportRepository : IRepository<ImpeachReport>
    {
        /// <summary>
        /// 获取举报的分页集合
        /// </summary>
        /// <param name="isDisposed">是否已处理</param>
        /// <param name="impeachReason">举报原因</param>
        /// <param name="startTtime">开始时间</param>
        /// <param name="endTtime">结束时间</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="pageIndex">当前页码</param>
        /// <returns>举报分页集合</returns>
        PagingDataSet<ImpeachReport> GetsForAdmin(bool? isDisposed, ImpeachReasonEnum? impeachReason, DateTime? startTtime, DateTime? endTtime, int pageSize = 20, int pageIndex = 1);

        /// <summary>
        /// 删除垃圾数据
        /// </summary>
        void DeleteTrashDatas();
    }
}