﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System;
using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 用户举报的数据访问层实现
    /// </summary>
    public class ImpeachReportRepository : Repository<ImpeachReport>, IImpeachReportRepository
    {
        /// <summary>
        /// 获取举报的分页集合
        /// </summary>
        /// <param name="isDisposed">是否已处理</param>
        /// <param name="impeachReason">举报原因</param>
        /// <param name="startTtime">开始时间</param>
        /// <param name="endTtime">结束时间</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="pageIndex">当前页码</param>
        /// <returns>举报分页集合</returns>
        public PagingDataSet<ImpeachReport> GetsForAdmin(bool? isDisposed, ImpeachReasonEnum? impeachReason, DateTime? startTtime, DateTime? endTtime, int pageSize = 20, int pageIndex = 1)
        {
            Sql sql = Sql.Builder.Select("*").From("tn_ImpeachReports");
            Sql whereSql = Sql.Builder;
            if (isDisposed.HasValue)
                whereSql.Where("Status=@0", isDisposed.Value);

            if (impeachReason.HasValue)
                whereSql.Where("Reason=@0", impeachReason.Value);
            if (startTtime.HasValue && endTtime.HasValue)
                whereSql.Where("DateCreated>=@0 and DateCreated<=@1 ", startTtime.Value, endTtime.Value.AddDays(1).AddSeconds(-1));
            sql.Append(whereSql).OrderBy("DateCreated desc");
            return GetPagingEntities(pageSize, pageIndex, sql);
        }

        /// <summary>
        /// 删除垃圾数据
        /// </summary>
        public void DeleteTrashDatas()
        {
            IEnumerable<TenantType> tenantTypes = new TenantTypeRepository().Gets(MultiTenantServiceKeys.Instance().ImpeachReport());

            List<Sql> sqls = new List<Sql>();
            foreach (var tenantType in tenantTypes)
            {
                Type type = Type.GetType(tenantType.ClassType);
                if (type == null)
                    continue;

                var pd = TableInfo.FromPoco(type);
                sqls.Add(Sql.Builder.Append("delete from tn_ImpeachReports")
                                    .Where("not exists (select 1 from " + pd.TableName + "  where tn_ImpeachReports.ReportObjectId = " + pd.TableName + "." + pd.PrimaryKey + ") and tn_ImpeachReports.TenantTypeId = @0"
                                    , tenantType.TenantTypeId));
            }

            CreateDAO().Execute(sqls);
        }
    }
}