﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章条件实体
    /// </summary>
    [TableName("tn_MedalConditions")]
    [PrimaryKey("ConditionId", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class MedalCondition : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static MedalCondition New()
        {
            MedalCondition medalCondition = new MedalCondition
            {
                ConditionName = string.Empty,
                MethodName = string.Empty
            };
            return medalCondition;
        }

        #region 需持久化属性

        /// <summary>
        /// 条件Id
        /// </summary>
        public long ConditionId { get; set; }

        /// <summary>
        /// 条件名
        /// </summary>
        public string ConditionName { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public long DisplayOrder { get; set; }

        /// <summary>
        /// 验证方法名（接收最小条件值和验证用户id）
        /// </summary>
        public string MethodName { get; set; }

        #endregion 需持久化属性



        #region 扩展属性/方法

        /// <summary>
        /// 最小条件值
        /// </summary>
        [Ignore]
        public int MinCondition { get; set; }

        #endregion 扩展属性/方法

        #region IEntity 成员

        object IEntity.EntityId { get { return this.ConditionId; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}