﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章互斥组实体
    /// </summary>
    [TableName("tn_MedalGroups")]
    [PrimaryKey("GroupId", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class MedalGroup : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static MedalGroup New()
        {
            MedalGroup medalGroup = new MedalGroup
            {
                GroupName = string.Empty,
                DateCreated = DateTime.Now
            };
            return medalGroup;
        }

        #region 需持久化属性

        /// <summary>
        /// 互斥组Id
        /// </summary>
        public long GroupId { get; set; }

        /// <summary>
        /// 互斥组名
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 勋章个数
        /// </summary>
        public int MeadlCount { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime DateCreated { get; set; }

        #endregion 需持久化属性



        #region IEntity 成员

        object IEntity.EntityId { get { return this.GroupId; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}