﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章条件关联实体
    /// </summary>
    [TableName("tn_MedalInConditions")]
    [PrimaryKey("Id", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class MedalInCondition : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static MedalInCondition New()
        {
            MedalInCondition medalInCondition = new MedalInCondition
            {
            };
            return medalInCondition;
        }

        #region 需持久化属性

        /// <summary>
        /// Id
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        /// 勋章Id
        /// </summary>
        public long MedalId { get; set; }

        /// <summary>
        /// 条件Id
        /// </summary>
        public long ConditionId { get; set; }

        /// <summary>
        /// 最小条件值
        /// </summary>
        public int MinCondition { get; set; }

        #endregion 需持久化属性



        #region 扩展属性/方法

        /// <summary>
        /// 获取条件信息
        /// </summary>
        public MedalCondition GetConditionInfo()
        {
            return DIContainer.Resolve<MedalService>().GetCondition(ConditionId);
        }

        #endregion 扩展属性/方法

        #region IEntity 成员

        object IEntity.EntityId { get { return this.Id; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}