﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章实体
    /// </summary>
    [TableName("tn_MedalInGroups")]
    [PrimaryKey("Id", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class MedalInGroup : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static MedalInGroup New()
        {
            MedalInGroup medalInGroup = new MedalInGroup
            {
            };
            return medalInGroup;
        }

        #region 需持久化属性

        /// <summary>
        /// Id
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        /// 勋章Id
        /// </summary>
        public long MedalId { get; set; }

        /// <summary>
        /// 互斥组Id
        /// </summary>
        public long GroupId { get; set; }

        #endregion 需持久化属性



        #region IEntity 成员

        object IEntity.EntityId { get { return this.Id; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}