﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章实体
    /// </summary>
    [TableName("tn_MedalToUsers")]
    [PrimaryKey("Id", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class MedalToUser : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static MedalToUser New()
        {
            MedalToUser medalToUser = new MedalToUser
            {
                UserDisplayName = string.Empty,
                DateCreated = DateTime.Now
            };
            return medalToUser;
        }

        #region 需持久化属性

        /// <summary>
        /// Id
        /// </summary>
        public long Id { get; set; }

        /// <summary>
        /// 勋章Id
        /// </summary>
        public long MedalId { get; set; }

        /// <summary>
        /// 用户Id
        /// </summary>
        public long UserId { get; set; }

        /// <summary>
        /// 用户名
        /// </summary>
        public string UserDisplayName { get; set; }

        /// <summary>
        /// 管理者Id
        /// </summary>
        public long ManagerId { get; set; }

        /// <summary>
        /// 用户授予状态（已授予、已收回、已拒绝、申请中、已放弃）
        /// </summary>
        public UserAwardStatus UserAwardStatus { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime DateCreated { get; set; }

        #endregion 需持久化属性



        #region 扩展属性/方法

        /// <summary>
        /// 用户授予状态（已授予、已收回、已拒绝、申请中、已放弃）
        /// </summary>
        [Ignore]
        public UserAwardStatus UserAwardStatusBefore { get; set; }

        /// <summary>
        /// 获取勋章信息
        /// </summary>
        /// <returns></returns>
        public Medal GetMedalInfo()
        {
            return DIContainer.Resolve<MedalService>().Get(MedalId);
        }

        #endregion 扩展属性/方法

        #region IEntity 成员

        object IEntity.EntityId { get { return this.Id; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}