﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章条件关联数据库仓储接口
    /// </summary>
    public interface IMedalInConditionRepository : IRepository<MedalInCondition>
    {
        /// <summary>
        /// 删除勋章的条件设置
        /// </summary>
        /// <param name="medalId">勋章Id</param>
        void DeleteMedalInConditionByMedalId(long medalId);

        /// <summary>
        /// 获取勋章某条件的最小值
        /// </summary>
        /// <returns>勋章条件的最小值</returns>
        /// <param name="conditionId">条件Id</param>
        /// <param name="medalId">勋章Id</param>
        /// <returns></returns>
        int GetMinCondition(long conditionId, long medalId);

        /// <summary>
        /// 获取某勋章的条件信息
        /// </summary>
        /// <param name="medalId">勋章Id</param>
        /// <returns>勋章关系关联</returns>
        IEnumerable<MedalInCondition> GetMedalInConditionBymedalId(long medalId);
    }
}