﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章互斥组关联数据库仓储接口
    /// </summary>
    public interface IMedalInGroupRepository : IRepository<MedalInGroup>
    {
        /// <summary>
        /// 删除勋章的互斥组设置
        /// </summary>
        /// <param name="medalId">勋章Id</param>
        void DeleteMedalInGroupByMedalId(long medalId);

        /// <summary>
        /// 获取互斥组勋章数量
        /// </summary>
        /// <returns>互斥组勋章数量</returns>
        /// <param name="groupId">互斥组Id</param>
        /// <returns></returns>
        int GetMedalCount(long groupId);

        /// <summary>
        /// 获取互斥组Id
        /// </summary>
        /// <returns>互斥组Id</returns>
        long GetGroupId(long medalId);
    }
}