﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章数据库仓储接口
    /// </summary>
    public interface IMedalRepository : IRepository<Medal>
    {
        /// <summary>
        /// 获取勋章列表（后台管理、我的/他的勋章）
        /// </summary>
        /// <param name="awardStatus">授予状态</param>
        /// <param name="userId">用户Id</param>
        /// <returns></returns>
        IEnumerable<Medal> Gets(AwardStatus? awardStatus = null, long userId = 0);

        /// <summary>
        /// 获取回答问题数量
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        int GetAnwerNum(long userId);

        /// <summary>
        /// 获取评论回复数量
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        int GetCommentNum(long userId);
    }
}