﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章用户关联数据库仓储接口
    /// </summary>
    public interface IMedalToUserRepository : IRepository<MedalToUser>
    {
        /// <summary>
        /// 获取勋章授予记录（后台管理）
        /// </summary>
        /// <param name="userId">用户Id</param>
        /// <param name="medalId">勋章Id</param>
        /// <param name="userAwardStatus">授予勋章状态</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="pageIndex">当前页码</param>
        /// <returns></returns>
        PagingDataSet<MedalToUser> GetsMedalToUser(List<string> userId = null, long medalId = 0, UserAwardStatus? userAwardStatus = null, int pageSize = 20, int pageIndex = 1);

        /// <summary>
        /// 获取勋章授予记录（前台勋章获取记录）
        /// </summary>
        /// <param name="topNumber">前几条</param>
        /// <returns></returns>
        IEnumerable<MedalToUser> GetTopsMedalToUser(int topNumber);

        /// <summary>
        /// 获取用户某互斥组下的勋章授予记录Id
        /// </summary>
        /// <param name="groupId">互斥组Id</param>
        /// <param name="userId">用户Id</param>
        /// <returns></returns>
        long GetMedaltoUserByGroupId(long groupId, long userId);

        /// <summary>
        /// 删除勋章授予记录
        /// </summary>
        /// <param name="medalId">勋章Id</param>
        void DeleteMedaltoUserByMedalId(long medalId);

        /// <summary>
        /// 批量更改author字段
        /// </summary>
        void UpdateMedalToUserAuthor(long userId, string displayName);
    }
}