﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System.Collections.Generic;
using System.Linq;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章关系关联数据库仓储
    /// </summary>
    public class MedalInConditionRepository : Repository<MedalInCondition>, IMedalInConditionRepository
    {
        /// <summary>
        /// 删除勋章的条件设置
        /// </summary>
        /// <param name="medalId">勋章Id</param>
        public void DeleteMedalInConditionByMedalId(long medalId)
        {
            var sql = Sql.Builder;
            sql.Append("Delete from tn_MedalInConditions");
            if (medalId > 0)
            {
                sql.Where("MedalId=@0", medalId);
                CreateDAO().Execute(sql);
            }
        }

        /// <summary>
        /// 获取勋章某条件的最小值
        /// </summary>
        /// <returns>勋章条件的最小值</returns>
        /// <param name="conditionId">条件Id</param>
        /// <param name="medalId">勋章Id</param>
        /// <returns></returns>
        public int GetMinCondition(long conditionId, long medalId)
        {
            var sql = Sql.Builder;
            sql.Where("ConditionId=@0", conditionId);
            sql.Where("MedalId=@0", medalId);
            var medalInCondition = CreateDAO().Fetch<MedalInCondition>(sql);
            if (medalInCondition.Count == 1)
                return medalInCondition.FirstOrDefault().MinCondition;
            else
                return 0;
        }

        /// <summary>
        /// 获取某勋章的条件信息
        /// </summary>
        /// <param name="medalId">勋章Id</param>
        /// <returns>勋章关系关联</returns>
        public IEnumerable<MedalInCondition> GetMedalInConditionBymedalId(long medalId)
        {
            var sql = Sql.Builder;
            sql.Where("MedalId=@0", medalId);
            return CreateDAO().Fetch<MedalInCondition>(sql);
        }
    }
}