﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System.Linq;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章互斥组关联数据库仓储
    /// </summary>
    public class MedalInGroupRepository : Repository<MedalInGroup>, IMedalInGroupRepository
    {
        /// <summary>
        /// 删除勋章的互斥组设置
        /// </summary>
        /// <param name="medalId">勋章Id</param>
        public void DeleteMedalInGroupByMedalId(long medalId)
        {
            var sql = Sql.Builder;
            sql.Append("Delete from tn_MedalInGroups");
            if (medalId > 0)
            {
                sql.Where("MedalId=@0", medalId);
                CreateDAO().Execute(sql);
            }
        }

        /// <summary>
        /// 获取互斥组勋章数量
        /// </summary>
        /// <returns>互斥组勋章数量</returns>
        /// <param name="groupId">互斥组Id</param>
        /// <returns></returns>
        public int GetMedalCount(long groupId)
        {
            var sql = Sql.Builder;
            sql.Where("GroupId=@0", groupId);
            return CreateDAO().Fetch<MedalInGroup>(sql).Count;
        }

        /// <summary>
        /// 获取互斥组Id
        /// </summary>
        /// <returns>互斥组Id</returns>
        /// <param name="medalId">勋章Id</param>
        public long GetGroupId(long medalId)
        {
            var sql = Sql.Builder;
            sql.Where("MedalId=@0", medalId);
            var medalInGroup = CreateDAO().Fetch<MedalInGroup>(sql);
            if (medalInGroup.Count > 0)
                return medalInGroup.FirstOrDefault().GroupId;
            else
                return 0;
        }
    }
}