﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using PetaPoco;
using System.Collections.Generic;
using System.Linq;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 勋章数据库仓储
    /// </summary>
    public class MedalRepository : Repository<Medal>, IMedalRepository
    {
        /// <summary>
        /// 获取勋章列表（后台管理、我的/他的勋章）
        /// </summary>
        /// <param name="awardStatus">授予状态</param>
        /// <param name="userId">用户Id</param>
        /// <returns></returns>
        public IEnumerable<Medal> Gets(AwardStatus? awardStatus = null, long userId = 0)
        {
            var sql = Sql.Builder;
            if (awardStatus.HasValue)
                sql.Where("AwardStatus=@0", awardStatus);
            if (userId > 0)
                sql.Where("UserId=@0", userId);
            sql.OrderBy("DisplayOrder");
            return CreateDAO().Query<Medal>(sql);
        }

        /// <summary>
        /// 获取回答问题数量
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetAnwerNum(long userId)
        {
            var sql = Sql.Builder;
            sql.Select("AnswerId").From("spb_Answers");
            sql.Where("UserId=@0", userId);
            try
            {
                var AnwerNum = CreateDAO().Fetch<long>(sql);
                return AnwerNum.Any() ? AnwerNum.Count() : 0;
            }
            catch
            {
                return 0;
            }
        }

        /// <summary>
        /// 获取评论回复数量
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetCommentNum(long userId)
        {
            var sql = Sql.Builder;
            sql.Select("Id").From("tn_Comments");
            sql.Where("UserId=@0", userId);
            var CommentNum = CreateDAO().Fetch<long>(sql);
            return CommentNum.Any() ? CommentNum.Count() : 0;
        }
    }
}