﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using System.Collections.Generic;

namespace Tunynet.Common
{
    /// <summary>
    /// 通知发送接口
    /// </summary>
    public interface INoticeSender
    {
        /// <summary>
        /// 发送方式
        /// </summary>
        /// <returns></returns>
        int SendMode();

        /// <summary>
        /// 通知发送
        /// </summary>
        /// <param name="notice"></param>
        /// <returns></returns>
        bool Send(Notice notice);

        /// <summary>
        /// 通知发送
        /// </summary>
        /// <param name="notice"></param>
        /// <returns></returns>
        bool Send(IEnumerable<Notice> notice);
    }
}