﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

namespace Tunynet.Common
{
    /// <summary>
    /// 通知类型状态
    /// </summary>
    public class NoticeTypeKeys
    {
        #region Instance

        private static NoticeTypeKeys _instance = new NoticeTypeKeys();

        /// <summary>
        /// 获取单例
        /// </summary>
        /// <returns></returns>
        public static NoticeTypeKeys Instance()
        {
            return _instance;
        }

        private NoticeTypeKeys()
        { }

        #endregion Instance

        /// <summary>
        /// 关注用户
        /// </summary>
        /// <returns></returns>
        public string FollowUser()
        {
            return "FollowUser";
        }

        /// <summary>
        /// 新回复
        /// </summary>
        /// <param name="tenantTypeId">租户Id</param>
        /// <returns></returns>
        public string NewReply(string tenantTypeId)
        {
            if (tenantTypeId == TenantTypeIds.Instance().Thread())
            {
                return "NewThreadReply";
            }
            else if (tenantTypeId == TenantTypeIds.Instance().CMS_Article())
            {
                return "NewArticleReply";
            }
            else if (tenantTypeId == TenantTypeIds.Instance().CMS_Image())
            {
                return "NewImageReply";
            }
            else if (tenantTypeId == TenantTypeIds.Instance().CMS_Video())
            {
                return "NewVideoReply";
            }
            else
            {
                return "NewCommentReply";
            }
        }

        /// <summary>
        /// 你的“XXX”通过了审核
        /// </summary>
        /// <returns></returns>
        public string ManagerApproved(string tenantTypeId)
        {
            if (tenantTypeId == TenantTypeIds.Instance().Thread())
                return "ThreadApproved";
            else if (tenantTypeId == TenantTypeIds.Instance().CMS_Article())
                return "CMSArticleApproved";
            return string.Empty;
        }

        /// <summary>
        /// 你的“XXX”未通过审核
        /// </summary>
        /// <returns></returns>
        public string ManagerDisapproved(string tenantTypeId)
        {
            if (tenantTypeId == TenantTypeIds.Instance().Thread())
                return "ThreadDisapproved";
            else if (tenantTypeId == TenantTypeIds.Instance().CMS_Article())
                return "CMSArticleDisapproved";
            return string.Empty;
        }

        /// <summary>
        /// 您申请的[勋章名称]通过批准
        /// </summary>
        /// <returns></returns>
        public string MedalApproved()
        {
            return "MedalApproved";
        }

        /// <summary>
        /// 您申请的[勋章名称]已被拒绝
        /// </summary>
        /// <returns></returns>
        public string MedalDisapproved()
        {
            return "MedalDisapproved";
        }

        /// <summary>
        /// 您的任务[任务名称]已通过审核，设置为完成。
        /// </summary>
        /// <returns></returns>
        public string TaskApproved()
        {
            return "TaskApproved";
        }

        /// <summary>
        ///您的任务[任务名称] 未通过审核，反馈意见为：[反馈意见]。
        /// </summary>
        /// <returns></returns>
        public string TaskDisapproved()
        {
            return "TaskDisapproved";
        }

        /// <summary>
        /// 您被授予新的勋章[勋章名称]
        /// </summary>
        /// <returns></returns>
        public string MedalAward()
        {
            return "MedalAward";
        }

        /// <summary>
        /// 您的勋章[勋章名称]被收回
        /// </summary>
        /// <returns></returns>
        public string MedalRecovered()
        {
            return "MedalRecovered";
        }
    }
}