﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Linq;
using Tunynet.Tasks;

namespace Tunynet.Common
{
    /// <summary>
    /// 通知分发任务
    /// </summary>
    public class NoticeDispatcherTask : ITask
    {
        private IEnumerable<INoticeSender> noticeSenders = DIContainer.Resolve<IEnumerable<INoticeSender>>();

        private NoticeService noticeService = DIContainer.Resolve<NoticeService>();

        /// <summary>
        /// 通知发送
        /// </summary>
        /// <param name="taskDetail"></param>
        /// <returns></returns>
        public void Execute(TaskDetail taskDetail = null)
        {
            IEnumerable<NoticeTypeSettings> Settings = null;
            var noticeTypeSettings = noticeService.GetAllTypeSetting();
            //遍历注入发送器
            foreach (var noticeSender in noticeSenders)
            {
                Settings = noticeTypeSettings.Where(n => n.SendMode == noticeSender.SendMode());
                foreach (var Setting in Settings)
                {
                    var notices = noticeService.GetNotices(Setting.NoticeTypeKey, Setting.Interval, 0);
                    noticeSender.Send(notices);
                }
            }
        }
    }
}