﻿//<tunynetcopyright>
//--------------------------------------------------------------
//<version>v0.5</verion>
//<createdate>2017-7-5</createdate>
//<author>zhangzh</author>
//<email>zhangzh@tunynet.com</email>
//<log date="2017-7-5" version="0.5">新建</log>
//--------------------------------------------------------------
//</tunynetcopyright>

using System.ComponentModel.DataAnnotations;

namespace Tunynet.Common
{
    /// <summary>
    /// 购买方式
    /// </summary>
    public enum Buyway
    {
        /// <summary>
        /// 支付宝
        /// </summary>
        [Display(Name = "支付宝")]
        AliPay = 10,

        /// <summary>
        /// 微信扫码
        /// </summary>
        [Display(Name = "微信支付")]
        WxPay = 20,
    }


    /// <summary>
    /// 支付来源介质类型
    /// </summary>
    public enum PayMediaType
    {
        /// <summary>
        /// 电脑端
        /// </summary>
        PC = 0,
        /// <summary>
        /// 手机浏览器
        /// </summary>
        WAP = 1,
        /// <summary>
        /// 微信公众号
        /// </summary>
        WeiXinMP = 2,

        /// <summary>
        /// 手机APP端
        /// </summary>
        APP = 3

    }
    /// <summary>
    /// 订单状态
    /// </summary>
    public enum RechargeOrdeStatus
    {
        /// <summary>
        /// 已取消
        /// </summary>
        [Display(Name = "已取消")]
        Cancel = 5,

        /// <summary>
        /// 未付款
        /// </summary>
        [Display(Name = "未付款")]
        NotPay = 10,

        /// <summary>
        /// 已完成
        /// </summary>
        [Display(Name = "交易完成")]
        Complete = 20,
    }
}