﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using System;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分记录仓储
    /// </summary>
    public interface IPointRechargeOrderRepository : IRepository<PointRechargeOrder>
    {
        /// <summary>
        /// 获取积分充值记录列表
        /// </summary>
        /// <param name="userId">用户Id</param>
        /// <param name="startDate">开始时间</param>
        /// <param name="endDate">结束时间</param>
        /// <param name="pageSize">个数</param>
        /// <param name="pageIndex">页码</param>
        /// <returns></returns>
        PagingDataSet<PointRechargeOrder> Gets(long userId = 0, DateTime? startDate = null, DateTime? endDate = null, int pageSize = 20, int pageIndex = 1);
    }
}