﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Repositories;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分记录仓储
    /// </summary>
    public class PointRechargeOrderRepository : Repository<PointRechargeOrder>, IPointRechargeOrderRepository
    {
        /// <summary>
        /// 获取积分充值记录列表
        /// </summary>
        /// <param name="userId">用户Id</param>
        /// <param name="startDate">开始时间</param>
        /// <param name="endDate">结束时间</param>
        /// <param name="pageSize">个数</param>
        /// <param name="pageIndex">页码</param>
        /// <returns></returns>
        public PagingDataSet<PointRechargeOrder> Gets(long userId = 0, DateTime? startDate = null, DateTime? endDate = null, int pageSize = 20, int pageIndex = 1)
        {
            Sql sql = Sql.Builder;
            if (userId > 0)
                sql.Where("tn_PointRechargeOrders.UserId=@0", userId);
            if (endDate.HasValue && startDate.HasValue)
                sql.Where("tn_PointRechargeOrders.DateCreated>=@0 and  tn_PointRechargeOrders.DateCreated<@1", startDate.Value, endDate.Value.AddDays(1).AddSeconds(-1));
            sql.OrderBy("tn_PointRechargeOrders.DateCreated desc");
            return GetPagingEntities(pageSize, pageIndex, sql);
        }
    }
}