﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------

using System.ComponentModel.DataAnnotations;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分任务状态
    /// </summary>
    public enum PointTaskStatus
    {
        /// <summary>
        /// 正常
        /// </summary>
        [Display(Name = "正常")]
        Normal = 1,

        /// <summary>
        /// 已过期
        /// </summary>
        [Display(Name = "已过期")]
        Expired = 2,

        /// <summary>
        /// 已禁用
        /// </summary>
        [Display(Name = "已禁用")]
        Disabled = 3
    }

    /// <summary>
    /// 积分任务领取状态
    /// </summary>
    public enum TaskRecordStatus
    {
        /// <summary>
        /// 进行中
        /// </summary>
        [Display(Name = "进行中")]
        Doing = 1,

        /// <summary>
        /// 申请完成中
        /// </summary>
        [Display(Name = "审核中")]
        Applying = 2,

        /// <summary>
        /// 已完成
        /// </summary>
        [Display(Name = "已完成")]
        Completed = 3,

        /// <summary>
        /// 未通过
        /// </summary>
        [Display(Name = "未通过")]
        Refused = 4,

        /// <summary>
        /// 已放弃
        /// </summary>
        [Display(Name = "已放弃")]
        Abandoned = 5
    }

    /// <summary>
    /// 分享方式
    /// </summary>
    public enum ShareType
    {
        /// <summary>
        /// 微信
        /// </summary>
        [Display(Name = "微信")]
        WeiXin = 1,

        /// <summary>
        /// QQ空间
        /// </summary>
        [Display(Name = "QQ空间")]
        QQ = 2
    }
}