﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分任务实体
    /// </summary>
    [TableName("tn_PointTaskRecords")]
    [PrimaryKey("RecordId", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class PointTaskRecord : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static PointTaskRecord New()
        {
            PointTaskRecord pointTaskRecord = new PointTaskRecord
            {
                UserDisplayName = string.Empty,
                ResultContent = string.Empty,
                Feedback = string.Empty,
                DateCreated = DateTime.Now
            };
            return pointTaskRecord;
        }

        #region 需持久化属性

        /// <summary>
        /// 领取记录Id
        /// </summary>
        public long RecordId { get; set; }

        /// <summary>
        /// 积分任务Id
        /// </summary>
        public long TaskId { get; set; }

        /// <summary>
        /// 用户Id
        /// </summary>
        public long UserId { get; set; }

        /// <summary>
        /// 用户名
        /// </summary>
        public string UserDisplayName { get; set; }

        /// <summary>
        /// 任务进行状态（进行中、申请完成中、已完成、未通过、已放弃）
        /// </summary>
        public TaskRecordStatus Status { get; set; }

        /// <summary>
        /// 用户针对内容项提交的内容（多个任务内容json存储）
        /// </summary>
        public string ResultContent { get; set; }

        /// <summary>
        /// 反馈意见
        /// </summary>
        public string Feedback { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime DateCreated { get; set; }

        #endregion 需持久化属性



        #region 扩展属性/方法

        /// <summary>
        /// 获取任务信息
        /// </summary>
        /// <returns></returns>
        public PointTask GetTaskInfo()
        {
            return DIContainer.Resolve<PointTaskService>().Get(TaskId);
        }

        #endregion 扩展属性/方法

        #region IEntity 成员

        object IEntity.EntityId { get { return this.RecordId; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}