﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
using PetaPoco;
using System;
using Tunynet.Caching;

namespace Tunynet.Common
{
    /// <summary>
    /// 积分任务实体
    /// </summary>
    [TableName("tn_PointTaskTypes")]
    [PrimaryKey("TypeId", autoIncrement = true)]
    [CacheSetting(true)]
    [Serializable]
    public class PointTaskType : IEntity
    {
        /// <summary>
        /// 初始化数据
        /// </summary>
        /// <returns></returns>
        public static PointTaskType New()
        {
            PointTaskType pointTaskType = new PointTaskType
            {
                TypeName = string.Empty,
                Description = string.Empty,
                TaskUrl = string.Empty,
                CheckMethodName = string.Empty,
                RouteName = string.Empty
            };
            return pointTaskType;
        }

        #region 需持久化属性

        /// <summary>
        /// 积分任务Id
        /// </summary>
        public long TypeId { get; set; }

        /// <summary>
        /// 积分任务名
        /// </summary>
        public string TypeName { get; set; }

        /// <summary>
        /// 是否显示进度条
        /// </summary>
        public bool IsShowProgressBar { get; set; }

        /// <summary>
        /// 是否可设截止日期
        /// </summary>
        public bool IsSetDeadline { get; set; }

        /// <summary>
        /// 能否添加任务
        /// </summary>
        public bool CanAddTask { get; set; }

        /// <summary>
        /// 完成规则说明
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 点击去做任务跳转的URL
        /// </summary>
        public string TaskUrl { get; set; }
        
        /// <summary>
        /// 手机端跳转类别
        /// </summary>
        public int TaskUrlType { get; set; }

        /// <summary>
        /// 检验任务是否完成的方法名（如果不填则表示需要人工审核）service中添加
        /// </summary>
        public string CheckMethodName { get; set; }

        /// <summary>
        /// 请求编辑时的action名。添加新的任务类型时需1、添加任务类型表记录2、添加一个编辑分布页3、添加control中对应的action方法
        /// </summary>
        public string RouteName { get; set; }

        /// <summary>
        /// 图标URL
        /// </summary>
        public string ImageUrl { get; set; }

        #endregion 需持久化属性



        #region IEntity 成员

        object IEntity.EntityId { get { return this.TypeId; } }

        bool IEntity.IsDeletedInDatabase { get; set; }

        #endregion IEntity 成员
    }
}